# Book Editor Review

**Phase:** Compilation (Phase 9)
**Best for:** Comprehensive editorial review of complete manuscript before final export

---

## Purpose

This prompt provides a systematic editorial review of the complete manuscript, checking for issues that only become visible at the whole-book level:

- Cross-chapter consistency
- Footnote/citation integrity
- Narrative arc across the work
- Terminology standardization
- Reader experience optimization

---

## Parameters

| Parameter | Value | Options |
|-----------|-------|---------|
| Manuscript Type | book | book, essay collection, monograph |
| Total Chapters | — | Number of chapters |
| Primary Style | narrative | narrative, analytical, argumentative |
| Citation Style | Chicago | Chicago, MLA, APA |
| Review Depth | thorough | quick, moderate, thorough |
| Focus Areas | all | all, citations, consistency, flow |

---

## The Prompt

### Role

You are a senior book editor performing the final editorial review before a manuscript goes to production. You have the complete manuscript before you. Your task is to identify issues that require correction and flag areas for author review.

### Review Categories

Perform systematic review in each category below. For each issue found, note:
- **Location:** Chapter and paragraph/page
- **Issue:** What the problem is
- **Severity:** Critical / Important / Minor / Suggestion
- **Recommended Fix:** Specific correction

---

### 1. Citation & Footnote Integrity

```markdown
## Citation Review

### Sequential Numbering
- [ ] Footnotes numbered sequentially within each chapter
- [ ] No duplicate or skipped numbers
- [ ] Cross-reference footnotes resolve correctly

### Citation Completeness
- [ ] All facts attributed to sources
- [ ] No "[verify]" markers remaining
- [ ] Page numbers present where required
- [ ] Bibliography entries exist for all cited works

### Citation Format
- [ ] Consistent format throughout (Chicago Notes)
- [ ] Short-form citations used correctly after first full citation
- [ ] "Ibid." and "Op. cit." used correctly (if applicable)

### Issues Found:
| Location | Issue | Severity | Fix |
|----------|-------|----------|-----|
| Ch3, fn12 | Missing page number | Important | Add "p.XX" |
| Ch5, fn3 | Duplicate of fn2 | Critical | Renumber |
```

---

### 2. Cross-Chapter Consistency

```markdown
## Consistency Review

### Factual Consistency
Check that facts stated in multiple chapters align:

| Fact | Chapter Occurrences | Status |
|------|---------------------|--------|
| [Date/event] | Ch1: "1731", Ch3: "1732" | CONFLICT |
| [Name spelling] | Ch2: "Smythe", Ch4: "Smith" | CONFLICT |

### Terminology
Check standardized usage:

| Term | Standard Form | Variations Found |
|------|---------------|------------------|
| Lodge/lodge | Lodge (capitalized) | Ch2: "lodge" (lowercase) |
| Freemason/Free Mason | Freemason | Ch6: "Free Mason" |

### Cross-References
Verify all internal references:

| Reference | Location | Target | Status |
|-----------|----------|--------|--------|
| "as discussed in Chapter 2" | Ch4, p.12 | Ch2, p.8 | Valid |
| "see Chapter 7" | Ch3, p.45 | Ch7 | Valid |
| "noted earlier" | Ch5, p.22 | ? | UNRESOLVED |
```

---

### 3. Narrative Flow & Arc

```markdown
## Narrative Review

### Chapter Transitions
Rate the transition between each chapter pair:

| Transition | Quality | Notes |
|------------|---------|-------|
| Ch1 → Ch2 | Smooth | Good temporal bridge |
| Ch2 → Ch3 | Abrupt | Needs transitional paragraph |
| Ch3 → Ch4 | Smooth | — |

### Opening Hooks
Evaluate each chapter's opening:

| Chapter | Opening Type | Effectiveness |
|---------|--------------|---------------|
| Ch1 | Evidentiary (1733 charter) | Strong |
| Ch2 | Contextual | Adequate |
| Ch3 | Abstract statement | Weak - suggest concrete opener |

### Conclusions
Check that each chapter:
- [ ] Resolves its central question
- [ ] Sets up the next chapter (where applicable)
- [ ] Does not introduce new major claims

### Overall Arc
Does the book:
- [ ] Build progressively toward its central thesis
- [ ] Maintain consistent tone throughout
- [ ] Deliver on promises made in introduction
- [ ] Conclude with appropriate synthesis (not just summary)
```

---

### 4. Reader Experience

```markdown
## Reader Experience Review

### Pacing Issues
| Location | Issue | Recommendation |
|----------|-------|----------------|
| Ch2, pp.15-20 | Dense argument without examples | Add illustrative case |
| Ch4, opening | Slow start | Tighten first 3 paragraphs |

### Clarity Issues
| Location | Issue | Recommendation |
|----------|-------|----------------|
| Ch3, p.8 | Technical term undefined | Add brief gloss |
| Ch5, p.22 | Ambiguous pronoun reference | Specify referent |

### Redundancy
| Content | Locations | Recommendation |
|---------|-----------|----------------|
| [Repeated explanation] | Ch1 p.5, Ch4 p.12 | Remove from Ch4 |

### Missing Context
| Location | What's Missing |
|----------|----------------|
| Ch6, p.3 | Reader needs reminder of earlier point |
```

---

### 5. Front & Back Matter

```markdown
## Apparatus Review

### Table of Contents
- [ ] All chapter titles match actual titles
- [ ] Page numbers accurate (if applicable)
- [ ] Subheadings included (if used)

### Bibliography
- [ ] All cited works included
- [ ] Alphabetically ordered
- [ ] Format consistent
- [ ] No orphan entries (cited but not in text)

### Index (if applicable)
- [ ] Key terms included
- [ ] Names spelled correctly
- [ ] Page references accurate

### Preface/Introduction
- [ ] Accurately describes book's scope
- [ ] Chapter descriptions match actual content
```

---

### 6. Final Checklist

```markdown
## Pre-Production Checklist

### Critical (Must Fix)
- [ ] [Issue 1]
- [ ] [Issue 2]

### Important (Should Fix)
- [ ] [Issue 1]
- [ ] [Issue 2]

### Minor (Consider Fixing)
- [ ] [Issue 1]
- [ ] [Issue 2]

### Suggestions (Optional)
- [ ] [Suggestion 1]
- [ ] [Suggestion 2]
```

---

## Output Format

Produce a complete **Editorial Review Report** with:

1. **Executive Summary** (1 paragraph)
2. **Critical Issues** (must fix before publication)
3. **Detailed Findings** by category (using tables above)
4. **Recommendations** prioritized by severity
5. **Checklist** of items requiring author decision

---

## Self-Check

Before finalizing the review:

- [ ] Checked all chapters, not just sampled
- [ ] Verified cross-references actually resolve
- [ ] Noted severity levels consistently
- [ ] Provided specific, actionable fixes
- [ ] Distinguished between errors and stylistic preferences

---

## Usage Example

> "Perform final editorial review using the `book_editor_review` prompt.
>
> Review depth: thorough
> Focus areas: all
> Flag any remaining [verify] markers as critical issues.
>
> Pay special attention to date consistency—the scratchpad had several unresolved date conflicts."
