# Cohesion Check

**Phase:** Polish (Post-Processing)
**Best for:** Cross-chapter consistency review for books

---

## Parameters

Edit these values for your project:

| Parameter | Value | Options |
|-----------|-------|---------|
| Book Title | — | Your book title |
| Total Chapters | — | Number of chapters |
| Review Depth | thorough | quick, moderate, thorough |

### Focus Areas (select which to check)

| Area | Check? | What It Catches |
|------|--------|-----------------|
| Terminology | ✓ | Same concept called different names |
| Themes | ✓ | Themes introduced but not developed |
| Transitions | ✓ | Jarring jumps between chapters |
| References | ✓ | Inaccurate cross-references |

---

## The Prompt

You are a continuity editor reviewing a book manuscript for cross-chapter consistency and cohesion. Your task is to identify inconsistencies, strengthen thematic ties, and ensure the book reads as a unified work.

---

### Review Areas

#### 1. Terminology Consistency

Check that key terms are used consistently throughout:

**Look for:**
- Same concept called different names in different chapters
- Spelling variations of technical terms
- Definitions that shift or contradict
- Capitalization inconsistencies

**Key Terms to Track:**
> [List your important terms here]

#### 2. Thematic Threading

Verify that recurring themes are developed consistently:

**Look for:**
- Themes introduced but never developed
- Thematic contradictions between chapters
- Opportunities to strengthen thematic connections
- Motifs that could be echoed across chapters

**Themes to Track:**
> [List your recurring themes here]

#### 3. Chapter Transitions

Review how chapters connect to each other:

**Look for:**
- Does each chapter ending prepare for the next?
- Are there jarring jumps in topic or tone?
- Do opening paragraphs acknowledge what came before?
- Is there a sense of forward momentum?

#### 4. Cross-References

Check internal references and callbacks:

**Look for:**
- References to "as we saw in Chapter X" — are they accurate?
- Forward references ("we will explore...") — are they fulfilled?
- Footnotes referencing other chapters — are they correct?
- Repeated examples or quotes — are they consistent?

---

### Review Depth

**Quick Review:**
- Scan for obvious inconsistencies
- Check key terminology
- Review chapter openings and endings

**Moderate Review:**
- Check all focus areas systematically
- Create terminology tracking list
- Review all chapter transitions
- Verify cross-references

**Thorough Review:**
- Line-by-line terminology verification
- Theme tracking across all chapters
- Detailed transition analysis
- Complete cross-reference audit
- Style consistency check
- Voice consistency verification

---

### Output Format

Provide a structured report:

```markdown
# Cohesion Review Report

## Summary
[Overall assessment: How unified does the manuscript feel?]

## Terminology Issues
| Term | Chapter X says | Chapter Y says | Recommendation |
|------|----------------|----------------|----------------|
| [term] | [usage] | [different usage] | [fix] |

## Thematic Gaps
| Theme | Introduced | Expected Development | Status |
|-------|------------|---------------------|--------|
| [theme] | Chapter X | Chapter Y | Missing/Weak/Strong |

## Transition Problems
| From → To | Issue | Suggested Fix |
|-----------|-------|---------------|
| Ch 3 → Ch 4 | [problem] | [solution] |

## Cross-Reference Errors
| Location | Reference | Issue | Fix |
|----------|-----------|-------|-----|
| Ch 5, p. 12 | "as noted in Ch 2" | Not in Ch 2 | [correct chapter] |

## Recommended Fixes (Priority Order)
1. [Most important fix with location]
2. [Next fix]
3. [...]
```

---

## Fill In For Your Book

**Key Terms to Track:**
- [Term 1]
- [Term 2]
- [Term 3]

**Recurring Themes:**
- [Theme 1]
- [Theme 2]

**Characters/Entities:**
- [Name 1]
- [Name 2]

---

## Self-Edit Checklist

After review, verify:

- [ ] Is every key term used consistently?
- [ ] Do themes develop naturally across chapters?
- [ ] Does each chapter ending connect to the next?
- [ ] Are all cross-references accurate?
- [ ] Does the book read as a unified work?
- [ ] Is the voice consistent throughout?

---

## Usage Example

> "Run the `cohesion_check` prompt across all 8 chapters. Key terms to track: 'lodge', 'ritual', 'initiation'. Themes: the evolution of secrecy, the tension between tradition and reform. Use thorough review depth."
