# Scholarly Narrative

**Phase:** Drafting
**Best for:** Historical, evidence-based, research-driven writing

---

## Parameters

Edit these values for your project:

| Parameter | Value | Options |
|-----------|-------|---------|
| Project Type | book | book, essay, article |
| Chapter Number | — | Fill in for each chapter |
| Chapter Title | — | Fill in for each chapter |
| Style | academic | academic, accessible, historical |
| Audience | educated general | specialist, educated general, general |
| Tone | scholarly | scholarly, conversational, formal |
| Include Footnotes | yes | yes, no |
| Citation Style | Chicago | Chicago, MLA, APA |
| First Person | occasional | never, occasional, frequent |

---

## The Prompt

Write a continuous, coherent scholarly narrative that reconstructs a historical or conceptual puzzle through evidence. The prose should be clear, erudite, and engaging, but never forced, ornate, or mechanical.

### Overall Style

- Prioritize clarity, flow, and intellectual honesty over cleverness or structural tricks.
- Use a natural narrative motion: each paragraph should grow from the previous one through a logical or evidentiary connection, not through imposed formulas.
- Maintain a tone appropriate for a scholar writing to an informed colleague.

### Opening

Begin with a concrete evidentiary spark—a date, document, line, place, or object—that naturally introduces the chapter's central problem.

Do not announce structure ("In this chapter…"). Just begin with the evidence.

### Paragraphs & Structure

- Let paragraphs find their own natural length and shape.
- You may use any mixture of:
  - Short hinge paragraphs
  - Close-up analyses
  - Longer developmental sections
  - Brief synthesis passages
- Do not meet quotas or patterns. Vary shape as the evidence requires.
- Use subheadings only if the argument genuinely shifts.

### Transitions & Movement

- Use transitions that arise naturally from specific evidence or reasoning.
- Traditional transitions are allowed when they are the clearest choice.
- Avoid performative or over-engineered transitions.
- Let the sources themselves move the narrative forward.

### Voice

- Erudite but unshowy.
- Occasional first-person for method or scope is welcome ("I rely on the 1848 files…").
- Never use self-commendation ("definitive," "groundbreaking," etc.).

### Evidence

- Anchor important claims in named evidence: people, institutions, dates, documents, archival files, places, direct quotations, or textual features.
- Quotations should serve the argument. Use direct quotes when:
  - The exact phrasing matters (ritual language, technical terms, contested definitions)
  - The source's voice or style is itself evidence
  - Paraphrase would lose precision or nuance
- Integrate quotes naturally. Brief quotations (under ~40 words) flow within sentences.
- Analyze, don't just present. When you quote, show why it matters.
- Prefer paraphrase for routine factual claims.
- Mark evidentiary limits plainly ("The roster for 1852 is incomplete…").

### Footnotes

- Use Chicago Notes & Bibliography when sources are cited.
- Footnotes should do real work: attribute, locate, or interpret.
- No decorative or filler notes.
- If something requires later verification, mark it ("Smith, Title, p. xx [verify]").

### Tone & Diction

- Prefer specific nouns and active verbs over abstractions.
- Keep hedges and intensifiers minimal and purposeful.
- Avoid evaluative epithets.
- Avoid generic "this/that" as a subject—specify the referent when needed.

### Flexibility

You are not required to:
- Maintain specific paragraph lengths
- Avoid common transitions
- Produce certain numbers of details
- Apply structural templates
- Use short sentences every paragraph

Use whatever form best brings the argument, evidence, and historical reality into sharp view.

### Ending

Conclude with a synthesis that addresses the opening puzzle and indicates what remains uncertain—without melodrama or artificial closure.

---

## Self-Edit Checklist

After writing, verify:

- [ ] Does the narrative flow naturally from one paragraph to the next?
- [ ] Are the most important claims grounded in concrete evidence?
- [ ] Is the tone scholarly, lucid, and unforced?
- [ ] Are any phrases self-conscious, overwritten, or performing sophistication?
- [ ] Does the rhythm alternate naturally between detail and interpretation?

---

## Usage Example

> "Use the `scholarly_narrative` prompt to write Chapter 4: The Scottish Connection. Focus on the documentary evidence from the 1730s lodge records. Here are the key sources and outline points..."
