# Book Projects

This folder contains all book and writing projects created using the Research Development Framework.

## Creating a New Project

**Tell Claude:**

> "Create a new book project about [topic] with [N] chapters targeting [N] pages."

Or use the CLI directly:

```bash
./rdf outline "Your Topic" --chapters 5 --pages 100
```

This creates a project folder with the structure below.

---

## Project Structure

Each project follows this structure:

```
BOOK_[timestamp]_[hash]/
├── outline.yaml              ← Project configuration and chapter plan
├── workflow_state.json       ← Tracks current workflow phase
├── research_summary.md       ← Research phase output
├── gaps.md                   ← Identified research gaps
│
├── research/                 ← Research materials by chapter
│   ├── ch01_research.md
│   ├── ch02_research.md
│   ├── quotes_collection.md
│   └── web_research/         ← Tavily results (if used)
│
├── drafts/                   ← First drafts
│   ├── chapter_01_draft.md
│   ├── chapter_02_draft.md
│   └── ...
│
├── revised/                  ← After editing pass
│   ├── chapter_01_revised.md
│   ├── chapter_02_revised.md
│   └── ...
│
├── polished/                 ← Final chapter versions
│   ├── chapter_01.md
│   ├── chapter_02.md
│   └── ...
│
└── compiled/                 ← Final assembled manuscript
    ├── manuscript.md         ← Complete book
    ├── front_matter.md       ← Title, TOC, preface
    ├── back_matter.md        ← Bibliography, index
    └── final/                ← Publication-ready files
        └── [final files]
```

---

## Workflow Phases

| Phase | Input Folder | Output Folder |
|-------|--------------|---------------|
| Research | (library) | `research/` |
| Drafting | `research/` | `drafts/` |
| Revision | `drafts/` | `revised/` |
| Polish | `revised/` | `polished/` |
| Compile | `polished/` | `compiled/` |

---

## Key Files

### outline.yaml

Project configuration:

```yaml
title: "Your Book Title"
author: "Your Name"
target_pages: 100
style: accessible
audience: educated_general
citation_style: chicago

chapters:
  - number: 1
    title: "Chapter One Title"
    target_pages: 20
    key_themes: [theme1, theme2]
    focus: "Brief description"
```

### workflow_state.json

Tracks progress:

```json
{
  "current_phase": "drafting",
  "chapters_drafted": [1, 2],
  "chapters_revised": [1],
  "chapters_polished": [],
  "last_updated": "2024-12-14T10:30:00"
}
```

---

## See Also

- [Writing Project Workflow](../../docs/WRITING_PROJECT_WORKFLOW.md) - Complete step-by-step guide
- [Prompt Library](../../prompts/README.md) - Writing prompts for each phase
