# Projects

This folder contains all writing projects created using the Research Development Framework.

## Structure

```
projects/
├── books/              # Multi-chapter book projects
│   ├── BOOK_[timestamp]_[hash]/
│   └── .template/      # Template structure for new books
│
└── essays/             # Single-document essay projects
    └── ESSAY_[timestamp]_[hash]/
```

---

## Creating Projects

### Books

**Tell Claude:**
> "Create a new book project about [topic] with [N] chapters targeting [N] pages."

Or use the CLI:
```bash
./rdf outline "Your Topic" --chapters 5 --pages 100
```

### Essays

**Tell Claude:**
> "Write an essay about [topic] targeting [N] pages."

Or use the CLI:
```bash
./rdf essay "Your Topic" --pages 15
```

---

## Project Structure

### Book Projects

Each book project follows this structure:

```
BOOK_[timestamp]_[hash]/
├── outline.yaml              ← Project configuration and chapter plan
├── workflow_state.json       ← Tracks current workflow phase
├── research_summary.md       ← Research phase output
├── gaps.md                   ← Identified research gaps
│
├── research/                 ← Research materials by chapter
│   ├── ch01_research.md
│   └── web_research/         ← Tavily results (if used)
│
├── drafts/                   ← First drafts
│   ├── chapter_01_draft.md
│   └── ...
│
├── revised/                  ← After editing pass
│   ├── chapter_01_revised.md
│   └── ...
│
├── polished/                 ← Final chapter versions
│   ├── chapter_01.md
│   └── ...
│
└── compiled/                 ← Final assembled manuscript
    ├── manuscript.md
    ├── front_matter.md
    └── back_matter.md
```

### Essay Projects

```
ESSAY_[timestamp]_[hash]/
├── outline.yaml              ← Essay configuration
├── research_summary.md       ← Research notes
├── essay_draft.md            ← First draft
├── essay_revised.md          ← Revised version
└── essay_polished.md         ← Final version
```

---

## Workflow Phases

| Phase | Input | Output |
|-------|-------|--------|
| Research | Library search | `research/` |
| Drafting | Research notes | `drafts/` |
| Revision | Drafts | `revised/` |
| Polish | Revised | `polished/` |
| Compile | Polished | `compiled/` |

---

## See Also

- [Writing Project Workflow](../docs/WRITING_PROJECT_WORKFLOW.md) - Complete step-by-step guide
- [Prompt Library](../prompts/README.md) - Writing prompts for each phase
