"""
Research Development Framework - Pipeline Module

This module provides document processing pipelines for:
- Document ingestion (PDF, DOCX, TXT, MD, EPUB)
- Text chunking with overlap
- Embedding generation via OpenAI
- Concept extraction and taxonomy mapping
- Full-text and semantic search

Usage:
    from pipeline import ingest_documents, chunk_documents, generate_embeddings

    # Or run individual scripts:
    python -m pipeline.ingest_documents
    python -m pipeline.chunk_documents
    python -m pipeline.generate_embeddings
"""

__version__ = '1.0.0'
