# Documentation Index

Complete documentation for the Research Development Framework - a CLI-first research and book compilation system optimized for Claude Code orchestration.

---

## Quick Navigation

| I want to... | Read this |
|--------------|-----------|
| **Write a book or essay (complete guide)** | [Writing Project Workflow](WRITING_PROJECT_WORKFLOW.md) |
| **Have Claude guide me through a project** | [Writing Project Phase Guide](WRITING_PROJECT_PHASE_GUIDE.md) |
| **Browse writing prompts** | [Prompt Library](../prompts/README.md) |
| **Get started** | [Setup Guide](SETUP.md) |
| **See all features at a glance** | [Feature Map](FEATURE_MAP.md) |
| **Learn all CLI commands** | [CLI User Guide](CLI_USER_GUIDE.md) |
| **See common workflows** | [Canonical Workflows](CANONICAL_WORKFLOWS.md) |
| **Add documents to the library** | [Ingestion Guide](INGESTION_GUIDE.md) |
| **Run embeddings locally (free)** | [Local LLM Guide](LOCAL_LLM_GUIDE.md) |
| **Understand the database** | [Database Schema](DATABASE_SCHEMA.md) |
| **Extend the framework** | [Developer Guide](DEVELOPER_GUIDE.md) |

---

## Documentation Overview

### User Guides

| Document | Description |
|----------|-------------|
| [Writing Project Workflow](WRITING_PROJECT_WORKFLOW.md) | **Complete step-by-step guide** for books, essays, and research projects |
| [Writing Project Phase Guide](WRITING_PROJECT_PHASE_GUIDE.md) | **Claude-guided workflow** - Claude prompts you through each phase |
| [Prompt Library](../prompts/README.md) | **Writing prompts** for drafting, revision, and polish phases |
| [Setup Guide](SETUP.md) | Installation, configuration, database setup |
| [Feature Map](FEATURE_MAP.md) | **Complete specification** - architecture, all commands, JSON contracts |
| [CLI User Guide](CLI_USER_GUIDE.md) | **Detailed command reference** for all 17 `rdf` commands |
| [Canonical Workflows](CANONICAL_WORKFLOWS.md) | **5 core workflows** for 95% of use cases |
| [Ingestion Guide](INGESTION_GUIDE.md) | Document formats, metadata extraction, quality assessment |
| [Local LLM Guide](LOCAL_LLM_GUIDE.md) | Setting up Ollama for local embeddings |

### Technical Reference

| Document | Description |
|----------|-------------|
| [Database Schema](DATABASE_SCHEMA.md) | PostgreSQL tables, indexes, and common queries |
| [Developer Guide](DEVELOPER_GUIDE.md) | Architecture, extending the framework, API reference |

### Release Information

| Document | Description |
|----------|-------------|
| [Changelog](CHANGELOG.md) | Release notes |

### Archived Documentation

Historical documentation is in [archive/](archive/):
- `FUTURE_ENHANCEMENTS_COMPLETED.md` - Architectural review (all enhancements implemented)
- `ADVANCED_RAG_GUIDE.md` - Technical RAG implementation details
- `IMPLEMENTATION_SUMMARY.md` - Historical implementation notes

---

## Architecture

```
┌─────────────────────────────────────────────────────────────────────────────┐
│                           CLAUDE CODE (Agent)                                │
│     Planning  │  Judgment  │  Synthesis  │  Quality Evaluation              │
└─────────────────────────────────────────────────────────────────────────────┘
                                    │
                                    ▼
┌─────────────────────────────────────────────────────────────────────────────┐
│                              RDF CLI LAYER                                   │
│   rdf write  │  rdf book  │  rdf essay  │  rdf research  │  rdf validate    │
└─────────────────────────────────────────────────────────────────────────────┘
                                    │
                                    ▼
┌─────────────────────────────────────────────────────────────────────────────┐
│                           DATA SUBSTRATE                                     │
│   Ingest/OCR  │  Chunk  │  Embed  │  Search  │  Quote Extract  │  Validate  │
└─────────────────────────────────────────────────────────────────────────────┘
                                    │
                                    ▼
┌─────────────────────────────────────────────────────────────────────────────┐
│                              STORAGE                                         │
│              PostgreSQL + pgvector  │  File System (artifacts)              │
└─────────────────────────────────────────────────────────────────────────────┘
```

**Key Principle:** RDF does data operations, Claude Code does thinking.

---

## Quick Start

```bash
cd /var/www/html/research/Research_development

# Add documents
cp your-documents/*.pdf NEW_DOCS/
./rdf ingest NEW_DOCS/

# Search
./rdf search "your query" --limit 10

# Write an essay (runs to completion)
./rdf essay "Your Topic" --pages 15

# Write a book (pauses for review)
./rdf outline "Your Topic" --chapters 5 --pages 100
./rdf book projects/books/BOOK_xxx/outline.yaml

# Check status
./rdf status
./rdf health --format json
```

---

## CLI Commands

All commands use the unified `rdf` entrypoint with `--format json` support.

### Core Commands (12)

| Command | Purpose |
|---------|---------|
| `rdf ingest <path>` | Add documents to library |
| `rdf search "<query>"` | Search the library |
| `rdf fetch <chunk_id>` | Retrieve bounded chunk text |
| `rdf research "<question>"` | Autonomous research |
| `rdf quotes "<topic>"` | Extract evidence |
| `rdf outline "<topic>"` | Generate book outline |
| `rdf book <outline.yaml>` | Book compilation workflow |
| `rdf essay "<topic>"` | Essay generation |
| `rdf write "<topic>"` | Universal entry point |
| `rdf validate <file>` | Claim verification |
| `rdf polish <file>` | Style refinement |
| `rdf queue <action>` | Review queue management |
| `rdf status` | Workflow state |

### Utility Commands (10)

| Command | Purpose |
|---------|---------|
| `rdf health` | Library health scan |
| `rdf edit-meta <DOC_ID>` | Metadata corrections |
| `rdf assess <DOC_ID>` | Mechanical document assessment |
| `rdf graph query "<concept>"` | Knowledge graph queries |
| `rdf diff <a> <b>` | File comparison |
| `rdf config [action]` | Configuration management (entity extraction setup) |
| `rdf context [project_id]` | Agent session warm-start (resume context) |
| `rdf capabilities` | Agent capability manifest (bootstrapping) |
| `rdf entity <action>` | Entity/concept management (duplicates, merge, alias) |
| `rdf export bibliography` | Export bibliography (BibTeX, RIS, CSL-JSON) |

### Help

```bash
./rdf --help
./rdf commands              # List all commands as JSON
./rdf <command> --help      # Command-specific help
```

---

## Workflow Modes

**Claude Code Workflow (Recommended):** Human-guided, 9-phase process with explicit review at each step. See [Writing Project Workflow](WRITING_PROJECT_WORKFLOW.md).

**Direct CLI Mode:** For quick essay generation without step-by-step review:
```bash
./rdf essay "Topic" --pages 20
```

The `--autonomy` flag exists for CLI-only usage but is unnecessary when Claude Code orchestrates the workflow.

---

## Getting Help

1. Run any command with `--help`: `./rdf search --help`
2. List all commands: `./rdf commands`
3. Check [CLI User Guide](CLI_USER_GUIDE.md) for complete documentation
4. Check [Canonical Workflows](CANONICAL_WORKFLOWS.md) for standard workflows
