# Release Notes

Research Development Framework - Current Release

---

## Version 4.1.0 - Architectural Enhancements

### New Commands

#### Agent Session Management
- **`rdf context`** - Session warm-start command that returns a comprehensive context packet for resuming work on a project. Includes current phase, progress, blocking items, and suggested next actions.
- **`rdf capabilities`** - Agent bootstrapping meta-tool that returns a complete capability manifest, enabling Claude Code to discover RDF's full functionality in a single call.

#### Entity Management
- **`rdf entity`** - Full entity management CLI with subcommands:
  - `duplicates` - Find potential duplicate entities using fuzzy matching
  - `merge` - Merge entities (direct or via review queue)
  - `alias` - Add aliases to entities
  - `show` - Display entity details
  - `health` - Entity health check
  - `list` - List all entities

#### Bibliography Export
- **`rdf export`** - Export bibliographies in academic formats:
  - BibTeX (`.bib`) - For LaTeX and reference managers
  - RIS (`.ris`) - For EndNote, Zotero, Mendeley
  - CSL-JSON (`.json`) - For Pandoc and Zotero
  - Includes validation to check for missing fields

### Enhanced Queue Feedback

The review queue now supports structured feedback for nuanced research steering:

- **Rejection reason codes**: `insufficient_evidence`, `wrong_scope`, `duplicate`, `needs_web`, `needs_library`, `needs_constraints`, `defer`, `quality_concern`, `out_of_scope`, `merged`, `other`
- **Structured constraints**: Strategy override, source type, date range, domain whitelist/blacklist, modified query
- **Re-queue with modifications**: Rejected items can be automatically re-queued with adjusted parameters

```bash
# Reject with structured feedback
./rdf queue reject GAP_045 --reason needs_web --feedback "Academic sources only"

# Reject and re-queue with modifications
./rdf queue reject GAP_045 --requeue --strategy web --source-type academic
```

### Opt-in Generation Model (Completed)

Resolved the "Split Brain" architecture issue. Text generation now follows a clear model:

- **Default**: CLI returns data/briefs; Claude Code writes prose
- **Opt-in**: Use flags to delegate generation to CLI's internal LLM
  - `--delegate-drafting` for `rdf book` and `rdf essay`
  - `--use-internal-model` for `rdf polish`

### Documentation Updates

- Updated workflow documentation with session resumption guidance
- Added bibliography export to Phase 9 compilation workflow
- Documented all new commands in CLI User Guide
- Archived completed FUTURE_ENHANCEMENTS.md

---

## Current Release

### Overview

The Research Development Framework is a CLI-first research document management system optimized for Claude Code orchestration. RDF provides the data substrate (ingest, search, validate, govern) while Claude Code handles reasoning, planning, and synthesis.

### Core Features

#### Unified CLI
- **`rdf` CLI** - Single executable entrypoint for all commands
- **`rdf commands`** - List all commands as JSON for agent discovery
- All commands support `--format json` for structured output

#### Writing Commands
- **`rdf write`** - Universal entry point that infers essay vs book from parameters
- **`rdf essay`** - Single-command essay generation with full autonomy
- **`rdf outline`** - Generate book outlines from natural language prompts
- **`rdf book`** - Complete book compilation workflow

#### Research Commands
- **`rdf search`** - Hybrid search (keyword + semantic + re-ranking)
- **`rdf research`** - Autonomous iterative research agent
- **`rdf quotes`** - Extract verbatim evidence with citations
- **`rdf fetch`** - Bounded chunk retrieval with `--max-chars` limit

#### Quality Commands
- **`rdf validate`** - Verify claims against library sources
- **`rdf polish`** - Style refinement with citation preservation
- **`rdf queue`** - Review queue management for governance

#### Utility Commands
- **`rdf status`** - Workflow state viewer
- **`rdf health`** - Library health scan
- **`rdf assess`** - Mechanical document assessment
- **`rdf diff`** - File comparison (unified and JSON output)
- **`rdf edit-meta`** - Metadata corrections
- **`rdf graph`** - Knowledge graph queries

### Autonomy Levels

Control how much the agent pauses for review:

| Level | Checkpoints | Best For |
|-------|-------------|----------|
| `--autonomy full` | None (errors only) | "Just write it" |
| `--autonomy supervised` | After research, after draft | Balanced oversight |
| `--autonomy interactive` | All checkpoints | Careful work |

**Defaults:** `full` for essays, `supervised` for books.

### Provenance Tracking

Minimal provenance with 6 essential fields:
- `doc_id` - Document identifier
- `source_type` - "library" or "web"
- `page_range` - Page numbers
- `chunk_id` - Chunk identifier
- `extraction` - Extraction method
- `content_hash` - SHA-256 hash

### JSON Output Contract

All commands return structured JSON with `--format json`:

```json
{
  "status": "success",
  "code": "SUCCESS",
  "message": "Operation completed",
  "data": {},
  "warnings": [],
  "queue_items_created": 0,
  "next_suggested_commands": []
}
```

### System Requirements

- **Python**: 3.10+ (3.11 recommended)
- **PostgreSQL**: 14+ with pgvector (16+ recommended)
- **Disk**: ~500MB for dependencies + document storage
- **RAM**: 4GB minimum

---

## Supported Document Formats

| Format | Extension | Notes |
|--------|-----------|-------|
| PDF | `.pdf` | Best for born-digital PDFs |
| Word (Modern) | `.docx` | Preserves formatting metadata (python-docx) |
| Word (Legacy) | `.doc` | Uses pandoc, libreoffice, or antiword (fallback) |
| OpenDocument | `.odt` | LibreOffice/OpenOffice |
| Rich Text | `.rtf` | Microsoft Rich Text |
| Plain Text | `.txt` | UTF-8 encoding |
| Markdown | `.md` | Preserves YAML front matter |
| HTML | `.html` | Strips scripts/styles |
| CSV | `.csv` | Converts to readable text |
| JSON | `.json` | Extracts text values |

---

## Configuration

### Environment Files

- `.env` - API keys (OPENAI_API_KEY, TAVILY_API_KEY)
- `.env.db` - Database credentials

### Project Configuration

```yaml
# config/project.yaml
embeddings:
  provider: "openai"
  model: "text-embedding-3-small"
  dimension: 1536

agent_safety:
  allow_web_search: false
  require_approved_web_sources: true
  validation_required_before_polish: true

defaults:
  autonomy_essay: "full"
  autonomy_book: "supervised"
  strict_library_only: true
```
