"""
Pytest configuration and shared fixtures for Agent Orchestrator tests.
"""

import os
import tempfile
from pathlib import Path
from typing import Generator

import pytest

# Set test environment
os.environ.setdefault("TESTING", "true")
os.environ.setdefault("LOG_LEVEL", "DEBUG")


@pytest.fixture
def temp_dir() -> Generator[Path, None, None]:
    """Create a temporary directory for test files."""
    with tempfile.TemporaryDirectory() as tmpdir:
        yield Path(tmpdir)


@pytest.fixture
def temp_db_path(temp_dir: Path) -> Path:
    """Create a path for a temporary SQLite database."""
    return temp_dir / "test_orchestrator.db"


@pytest.fixture
def project_state_path(temp_dir: Path) -> Path:
    """Create a path for a temporary project_state.json."""
    return temp_dir / "project_state.json"


@pytest.fixture
def agent_journal_path(temp_dir: Path) -> Path:
    """Create a path for a temporary agent_journal.md."""
    return temp_dir / "agent_journal.md"


# Add more fixtures as needed during implementation
