"""
TUI - Terminal User Interface for Agent Orchestrator.

Provides:
- OrchestratorDashboard - Main dashboard application
- DashboardDataProvider - Interface for data providers
- run_dashboard - Entry point to run the dashboard

Example:
    from agent_orchestrator.tui import run_dashboard
    run_dashboard()
"""

from .app import (
    OrchestratorDashboard,
    DashboardDataProvider,
    run_dashboard,
)
from .widgets import (
    AgentStatusRow,
    AgentStatusPanel,
    TaskQueuePanel,
    ActiveTaskPanel,
    CostSummaryBar,
)

__all__ = [
    # Main app
    "OrchestratorDashboard",
    "DashboardDataProvider",
    "run_dashboard",
    # Widgets
    "AgentStatusRow",
    "AgentStatusPanel",
    "TaskQueuePanel",
    "ActiveTaskPanel",
    "CostSummaryBar",
]
