"""
Secret Handling - Protection against secret leakage.

This module implements secret protection:
- Log redaction for API keys, tokens, passwords
- Never-store patterns for sensitive files
- File access guards
"""

from .redactor import SecretRedactor
from .guard import SecretFileGuard, NEVER_STORE_PATTERNS

__all__ = ["SecretRedactor", "SecretFileGuard", "NEVER_STORE_PATTERNS"]
