"""
Risk Gate - Four-tier autonomy classification.

This module implements risk classification for agent actions:
- LOW: Auto-allowed (read files, run tests)
- MEDIUM: Edits OK, commands need approval
- HIGH: Suggest-only, ask user
- CRITICAL: Auto-reject (force push, terraform destroy)
"""

from .policy import (
    RiskPolicy,
    RiskLevel,
    RiskClassification,
    RiskDecision,  # Alias for backwards compatibility
    CRITICAL_COMMAND_PATTERNS,
    CRITICAL_FILE_PATTERNS,
    HIGH_RISK_COMMAND_PATTERNS,
    HIGH_RISK_FILE_PATTERNS,
    MEDIUM_RISK_COMMAND_PATTERNS,
    MEDIUM_RISK_FILE_PATTERNS,
    LOW_RISK_COMMAND_PATTERNS,
    LOW_RISK_FILE_PATTERNS,
)
from .blocklist import CRITICAL_BLOCKLIST, is_blocklisted, get_matching_pattern
from .autonomy_gate import AutonomyGate, GateDecision
from .configurable_policy import (
    ConfigurableRiskPolicy,
    RiskPolicyConfig,
    RiskPattern,
    get_configurable_policy,
    set_configurable_policy,
    load_policy_from_file,
)

__all__ = [
    "RiskPolicy",
    "RiskLevel",
    "RiskClassification",
    "RiskDecision",
    "CRITICAL_COMMAND_PATTERNS",
    "CRITICAL_FILE_PATTERNS",
    "HIGH_RISK_COMMAND_PATTERNS",
    "HIGH_RISK_FILE_PATTERNS",
    "MEDIUM_RISK_COMMAND_PATTERNS",
    "MEDIUM_RISK_FILE_PATTERNS",
    "LOW_RISK_COMMAND_PATTERNS",
    "LOW_RISK_FILE_PATTERNS",
    "CRITICAL_BLOCKLIST",
    "is_blocklisted",
    "get_matching_pattern",
    "AutonomyGate",
    "GateDecision",
]
