"""
Memory Layer - Two-tier memory architecture with controlled writes.

This module provides:
- Operational Memory: Authoritative system state (SQLite + /ops/ files)
- Knowledge Memory: RAG-based retrieval over knowledge base
- Working Memory: Per-task scratch space
- Memory Write Gate: Validation and approval routing for writes
- Memory Librarian: Automated maintenance and cleanup

Memory Hierarchy:
- Tier 0: Immutable Audit (task runs, logs, approvals)
- Tier 1: Authoritative (ADRs, policies, project_state.json)
- Tier 2: Working Knowledge (runbooks, prompts, patterns)
- Tier 3: Ephemeral Cache (raw tool outputs, scratch)

Usage:
    from agent_orchestrator.memory import (
        OperationalMemory,
        KnowledgeMemory,
        WorkingMemory,
        MemoryWriteGate,
    )
"""

from .models import (
    MemoryTier,
    MemoryItemType,
    MemoryItem,
    MemoryPatch,
    PatchOperation,
    PatchRiskLevel,
    PatchValidationResult,
    ContextPacket,
    create_add_runbook_patch,
    create_add_issue_fix_patch,
    create_tag_patch,
    create_supersede_patch,
)

from .operational import OperationalMemory

from .knowledge import (
    KnowledgeMemory,
    SearchResult,
)

from .working import (
    WorkingMemory,
    WorkingSession,
    WorkingNote,
    ToolOutput,
)

from .write_gate import (
    MemoryWriteGate,
    ApprovalRequest,
)

__all__ = [
    # Models
    "MemoryTier",
    "MemoryItemType",
    "MemoryItem",
    "MemoryPatch",
    "PatchOperation",
    "PatchRiskLevel",
    "PatchValidationResult",
    "ContextPacket",
    # Patch helpers
    "create_add_runbook_patch",
    "create_add_issue_fix_patch",
    "create_tag_patch",
    "create_supersede_patch",
    # Operational Memory
    "OperationalMemory",
    # Knowledge Memory
    "KnowledgeMemory",
    "SearchResult",
    # Working Memory
    "WorkingMemory",
    "WorkingSession",
    "WorkingNote",
    "ToolOutput",
    # Write Gate
    "MemoryWriteGate",
    "ApprovalRequest",
]
