"""
Human Interrupt Interface - User approval mechanisms.

This module provides:
- V1 (CLIInterruptHandler): Blocking CLI prompt
- V2 (AsyncInterruptHandler): Webhook/async with timeout
- ApprovalQueue: Centralized queue management

Usage:
    from agent_orchestrator.interrupt import (
        CLIInterruptHandler,
        AsyncInterruptHandler,
        ApprovalQueue,
        ApprovalResponse,
    )

    # CLI mode (blocking)
    cli_handler = CLIInterruptHandler(db)
    response = await cli_handler.request_approval(...)

    # Async mode (webhook)
    async_handler = AsyncInterruptHandler(db, webhook_config)
    response = await async_handler.request_approval(...)

    # Queue mode (auto-selects handler)
    queue = ApprovalQueue(db, cli_handler, async_handler)
    response = await queue.submit(...)
"""

from .cli_handler import (
    CLIInterruptHandler,
    CLIConfig,
    ApprovalDecision,
    ApprovalResponse,
    NonInteractiveHandler,
    get_cli_handler,
)

from .async_handler import (
    AsyncInterruptHandler,
    WebhookConfig,
    NotificationChannel,
    ApprovalCallbackServer,
)

from .approval_queue import (
    ApprovalQueue,
    QueueConfig,
    QueueStats,
    ApprovalPriority,
    HandlerMode,
)

__all__ = [
    # CLI Handler
    "CLIInterruptHandler",
    "CLIConfig",
    "NonInteractiveHandler",
    "get_cli_handler",
    # Async Handler
    "AsyncInterruptHandler",
    "WebhookConfig",
    "NotificationChannel",
    "ApprovalCallbackServer",
    # Queue
    "ApprovalQueue",
    "QueueConfig",
    "QueueStats",
    "ApprovalPriority",
    "HandlerMode",
    # Common
    "ApprovalDecision",
    "ApprovalResponse",
]
