"""
Interaction - CLI interaction detection and auto-response handling.

Provides:
- Interaction detection for CLI agents
- Risk assessment and classification
- Auto-response handling with policies
- Interaction routing and escalation
"""

from .detector import (
    InteractionType,
    RiskLevel,
    DetectedInteraction,
    InteractionDetector,
    check_process_for_input,
    get_interaction_detector,
    set_interaction_detector,
)
from .auto_handler import (
    ResponseAction,
    EscalationLevel,
    ResponseDecision,
    ResponsePolicy,
    AutoResponseHandler,
    InteractionRouter,
    get_auto_handler,
    set_auto_handler,
    get_interaction_router,
    set_interaction_router,
)

__all__ = [
    # Detector
    "InteractionType",
    "RiskLevel",
    "DetectedInteraction",
    "InteractionDetector",
    "check_process_for_input",
    "get_interaction_detector",
    "set_interaction_detector",
    # Auto-handler
    "ResponseAction",
    "EscalationLevel",
    "ResponseDecision",
    "ResponsePolicy",
    "AutoResponseHandler",
    "InteractionRouter",
    "get_auto_handler",
    "set_auto_handler",
    "get_interaction_router",
    "set_interaction_router",
]
