"""
Coordination - Advanced agent coordination patterns.

Provides:
- HandoffManager - Context transfer between agents
- SharedMemory - Shared state for workflows
- Checkpoints and recovery (future)

Example:
    from agent_orchestrator.coordination import (
        HandoffManager,
        HandoffReason,
        SharedMemoryManager,
    )

    # Agent handoff
    manager = HandoffManager()
    context = await manager.prepare_handoff(
        from_agent="claude-code",
        to_agent="gemini-cli",
        reason=HandoffReason.RATE_LIMITED,
        task_summary="Implementing auth",
    )
    await manager.execute_handoff(context)

    # Shared memory
    memory_mgr = SharedMemoryManager()
    memory = memory_mgr.get_or_create("workflow-123")
    await memory.write("config", {"timeout": 30}, "agent-1")
"""

from .handoff import (
    HandoffReason,
    HandoffContext,
    HandoffResult,
    HandoffManager,
    get_handoff_manager,
    set_handoff_manager,
)
from .shared_memory import (
    StateChange,
    SharedMemory,
    SharedMemoryManager,
    get_shared_memory_manager,
    set_shared_memory_manager,
)

__all__ = [
    # Handoff
    "HandoffReason",
    "HandoffContext",
    "HandoffResult",
    "HandoffManager",
    "get_handoff_manager",
    "set_handoff_manager",
    # Shared Memory
    "StateChange",
    "SharedMemory",
    "SharedMemoryManager",
    "get_shared_memory_manager",
    "set_shared_memory_manager",
]
