"""
Agents Module

Provides agent templates and development tools.
"""

from .templates import (
    AgentTemplate,
    AgentCapability,
    CollaborationStyle,
    AgentRole,
    AgentTeamComposition,
    TemplateRegistry,
    TemplateMatch,
    get_registry,
    get_template,
    list_templates,
    select_agents_for_task,
    compose_team_for_task,
)
from .development import (
    AgentDeveloper,
    TemplateWizard,
    TemplateValidation,
    TestResult,
    create_custom_template,
    load_custom_templates,
)

__all__ = [
    # Templates
    "AgentTemplate",
    "AgentCapability",
    "CollaborationStyle",
    "AgentRole",
    "AgentTeamComposition",
    "TemplateRegistry",
    "TemplateMatch",
    "get_registry",
    "get_template",
    "list_templates",
    "select_agents_for_task",
    "compose_team_for_task",
    # Development
    "AgentDeveloper",
    "TemplateWizard",
    "TemplateValidation",
    "TestResult",
    "create_custom_template",
    "load_custom_templates",
]
