# Agent Orchestrator Examples

This directory contains working examples demonstrating Agent Orchestrator features.

## Prerequisites

```bash
# Install the orchestrator
pip install -e ".[dev]"

# Ensure at least one CLI agent is authenticated
claude-code --version  # or gemini, codex
```

## Examples

### Basic

| Example | Description |
|---------|-------------|
| [simple_task.py](basic/simple_task.py) | Submit a single task |
| [task_with_options.py](basic/task_with_options.py) | Task with priority and retries |
| [list_agents.py](basic/list_agents.py) | List available agents |

### Workflows

| Example | Description |
|---------|-------------|
| [sequential_workflow.py](workflows/sequential_workflow.py) | Tasks in sequence |
| [parallel_workflow.py](workflows/parallel_workflow.py) | Parallel execution |
| [json_workflow.py](workflows/json_workflow.py) | JSON-defined workflow |

### Advanced

| Example | Description |
|---------|-------------|
| [voting_consensus.py](advanced/voting_consensus.py) | Multi-agent voting |
| [agent_handoff.py](advanced/agent_handoff.py) | Context handoff |
| [cost_tracking.py](advanced/cost_tracking.py) | Budget monitoring |
| [session_tracing.py](advanced/session_tracing.py) | Trace analysis |

## Running Examples

```bash
# Run a specific example
python examples/basic/simple_task.py

# Run with debug logging
LOG_LEVEL=DEBUG python examples/basic/simple_task.py
```

## API Examples

See [docs/api/examples/](../docs/api/examples/) for REST API usage examples.
