# Workflow Engine Diagram

This diagram shows the JSON-driven workflow engine.

## Workflow Execution Flow

```mermaid
flowchart TD
    subgraph "Workflow Definition"
        WD[workflow.json] --> V[Validate]
        V --> P[Parse Steps]
    end

    subgraph "Workflow Engine"
        P --> E[WorkflowEngine]
        E --> C[Create Context]
        C --> S1{Step Type?}

        S1 -->|task| T[Execute Task]
        S1 -->|parallel| PAR[Execute Parallel]
        S1 -->|conditional| COND[Evaluate Condition]
        S1 -->|wait| WAIT[Wait for Variable]
        S1 -->|approval| APP[Request Approval]
        S1 -->|vote| VOTE[Multi-Agent Vote]

        T --> R[Store Result]
        PAR --> R
        COND --> NS[Next Step]
        WAIT --> NS
        APP --> NS
        VOTE --> NS

        R --> NS
        NS --> S1
    end

    subgraph "Workflow Context"
        CTX[Context]
        CTX --> VARS[Variables]
        CTX --> RESULTS[Step Results]
        CTX --> STATE[Execution State]
    end
```

## Step Types

```mermaid
graph TB
    subgraph "Task Step"
        TS[task] --> TA[agent_id]
        TS --> TP[prompt]
        TS --> TT[timeout]
        TS --> TO[output_var]
    end

    subgraph "Parallel Step"
        PS[parallel] --> PST[steps: list]
        PS --> PM[max_concurrent]
        PS --> PF[fail_fast]
    end

    subgraph "Conditional Step"
        CS[conditional] --> CC[condition]
        CS --> CT[then_step]
        CS --> CE[else_step]
    end

    subgraph "Wait Step"
        WS[wait] --> WV[variable]
        WS --> WT[timeout]
        WS --> WD[default]
    end

    subgraph "Approval Step"
        AS[approval] --> AM[message]
        AS --> AT[timeout]
        AS --> AD[auto_approve]
    end

    subgraph "Vote Step"
        VS[vote] --> VT[topic]
        VS --> VO[options]
        VS --> VQ[quorum_type]
        VS --> VV[voters]
    end
```

## Example Workflow

```json
{
  "name": "feature-implementation",
  "variables": {
    "feature_name": "user-auth",
    "branch": "feature/user-auth"
  },
  "steps": [
    {
      "id": "design",
      "type": "task",
      "agent_id": "claude-code",
      "prompt": "Design the ${feature_name} feature architecture",
      "output_var": "design_doc"
    },
    {
      "id": "review-design",
      "type": "vote",
      "topic": "Approve design for ${feature_name}?",
      "options": ["approve", "revise", "reject"],
      "voters": ["claude-code", "gemini-cli"],
      "quorum_type": "simple_majority"
    },
    {
      "id": "implement",
      "type": "conditional",
      "condition": {
        "left": "${steps.review-design.result}",
        "op": "eq",
        "right": "approve"
      },
      "then_step": {
        "id": "parallel-impl",
        "type": "parallel",
        "steps": [
          {
            "id": "backend",
            "type": "task",
            "agent_id": "claude-code",
            "prompt": "Implement backend for ${feature_name}"
          },
          {
            "id": "frontend",
            "type": "task",
            "agent_id": "gemini-cli",
            "prompt": "Implement frontend for ${feature_name}"
          }
        ]
      },
      "else_step": {
        "id": "revise",
        "type": "task",
        "agent_id": "claude-code",
        "prompt": "Revise design based on feedback"
      }
    },
    {
      "id": "test",
      "type": "task",
      "agent_id": "codex-cli",
      "prompt": "Write and run tests for ${feature_name}",
      "dependencies": ["parallel-impl"]
    },
    {
      "id": "deploy-approval",
      "type": "approval",
      "message": "Deploy ${feature_name} to staging?",
      "timeout": 3600
    }
  ],
  "on_failure": "stop"
}
```

## Workflow Visualization

```mermaid
graph TD
    START((Start)) --> D[Design]
    D --> RD{Vote: Approve?}
    RD -->|Yes| PI[Parallel Implementation]
    RD -->|No| REV[Revise Design]
    REV --> D

    subgraph PI[Parallel Implementation]
        BE[Backend]
        FE[Frontend]
    end

    PI --> TEST[Run Tests]
    TEST --> DA{Approval: Deploy?}
    DA -->|Yes| DEPLOY[Deploy]
    DA -->|No| END((End))
    DEPLOY --> END
```

## Condition Operators

| Operator | Description | Example |
|----------|-------------|---------|
| `eq` | Equals | `"status" eq "success"` |
| `ne` | Not equals | `"count" ne 0` |
| `gt` | Greater than | `"score" gt 80` |
| `lt` | Less than | `"errors" lt 5` |
| `gte` | Greater or equal | `"coverage" gte 80` |
| `lte` | Less or equal | `"time" lte 300` |
| `contains` | String contains | `"output" contains "success"` |
| `not_contains` | String doesn't contain | `"log" not_contains "error"` |
| `is_true` | Boolean true | `"enabled" is_true` |
| `is_false` | Boolean false | `"disabled" is_false` |
| `exists` | Variable exists | `"result" exists` |
| `not_exists` | Variable doesn't exist | `"error" not_exists` |

## Variable Interpolation

Variables use `${variable}` syntax:

```yaml
# Simple variable
prompt: "Implement ${feature_name}"

# Nested access
prompt: "Previous result: ${steps.design.result.summary}"

# Step output
condition:
  left: "${steps.test.result.passed}"
  op: "eq"
  right: true
```

## Failure Handling

| Mode | Behavior |
|------|----------|
| `stop` | Stop workflow on first failure |
| `continue` | Continue with other steps |
| `rollback` | Execute rollback steps |

```json
{
  "on_failure": "rollback",
  "rollback_steps": [
    {
      "id": "cleanup",
      "type": "task",
      "agent_id": "claude-code",
      "prompt": "Rollback changes from failed deployment"
    }
  ]
}
```
