# System Overview Diagram

This diagram shows the high-level architecture of the Agent Orchestration system.

```mermaid
graph TB
    subgraph "User Interface Layer"
        CLI[CLI Commands]
        TUI[Terminal Dashboard]
        API[REST API]
    end

    subgraph "Orchestration Layer"
        Brain[OrchestrationBrain]
        Spawner[AgentSpawner]
        Commands[CommandProcessor]
        Workflow[WorkflowEngine]
    end

    subgraph "Coordination Layer"
        Loop[AgentControlLoop]
        Health[HealthMonitor]
        Handoff[HandoffManager]
        Voting[VotingCoordinator]
        Swarm[SwarmCoordinator]
    end

    subgraph "Control Layer"
        Risk[RiskGate]
        Budget[BudgetEnforcer]
        Tier[TierManager]
        Interact[InteractionRouter]
    end

    subgraph "Agent Layer"
        subgraph "CLI Agents"
            CC[Claude Code]
            GC[Gemini CLI]
            CX[Codex CLI]
        end
        subgraph "API Agents"
            CS[Claude SDK]
            OA[OpenAI Agents]
            GA[Gemini API]
        end
    end

    subgraph "Memory Layer"
        OM[OperationalMemory]
        KM[KnowledgeMemory]
        WM[WorkingMemory]
        SM[SharedMemory]
    end

    subgraph "Persistence Layer"
        DB[(SQLite)]
        Trace[(Trace Storage)]
        Files[/ops/ Files/]
    end

    CLI --> Brain
    TUI --> Brain
    API --> Brain

    Brain --> Loop
    Brain --> Spawner
    Brain --> Commands
    Brain --> Workflow

    Loop --> Health
    Loop --> Handoff
    Loop --> Voting
    Loop --> Swarm

    Handoff --> CC
    Handoff --> GC
    Handoff --> CX
    Swarm --> CS
    Swarm --> OA
    Swarm --> GA

    Loop --> Risk
    Loop --> Budget
    Loop --> Tier
    Loop --> Interact

    CC --> OM
    GC --> OM
    CX --> OM
    CS --> WM
    OA --> WM
    GA --> WM

    OM --> DB
    WM --> DB
    SM --> DB
    KM --> Files
    Health --> Trace
```

## Components

### User Interface Layer
- **CLI Commands** - Command-line interface for task submission
- **Terminal Dashboard** - Rich TUI for real-time monitoring
- **REST API** - HTTP API for external integrations

### Orchestration Layer
- **OrchestrationBrain** - Central coordinator for all operations
- **AgentSpawner** - Creates and manages agent processes
- **CommandProcessor** - Handles user commands
- **WorkflowEngine** - Executes JSON-defined workflows

### Coordination Layer
- **AgentControlLoop** - Main event loop for agent management
- **HealthMonitor** - Detects stuck/failed agents
- **HandoffManager** - Context transfer between agents
- **VotingCoordinator** - Multi-agent decision making
- **SwarmCoordinator** - Parallel task distribution

### Control Layer
- **RiskGate** - Four-tier risk classification
- **BudgetEnforcer** - Cost and usage limits
- **TierManager** - Subscription tier limits
- **InteractionRouter** - Auto-response handling

### Agent Layer
- **CLI Agents** - Interactive agents via terminal
- **API Agents** - Programmatic agents via SDK

### Memory Layer
- **OperationalMemory** - Audit logs, task history
- **KnowledgeMemory** - ADRs, policies, prompts
- **WorkingMemory** - Active context, scratch data
- **SharedMemory** - Cross-agent workflow state

### Persistence Layer
- **SQLite** - Primary database
- **Trace Storage** - Session tracing data
- **ops/ Files** - Configuration and runbooks
