# Risk Gate Flow Diagram

This diagram shows the risk classification and gating logic.

```mermaid
flowchart TD
    A[Action Request] --> B{Check Blocklist}
    B -->|Blocked Pattern| C[CRITICAL: Auto-Reject]
    B -->|Not Blocked| D{Classify Command Risk}

    D --> E{Command Type}
    E -->|Read Only| F[LOW Risk]
    E -->|Modify Files| G[Check File Path]
    E -->|Execute Command| H[Check Command Pattern]
    E -->|Network/Deploy| I[HIGH Risk]

    G -->|Protected Path| J[HIGH Risk]
    G -->|Normal Path| K[MEDIUM Risk]

    H -->|Safe Commands| L[LOW Risk]
    H -->|Install/Build| M[MEDIUM Risk]
    H -->|Destructive| N[HIGH Risk]
    H -->|Force/Delete| O[CRITICAL Risk]

    F --> P{Apply Overrides}
    K --> P
    L --> P
    M --> P
    N --> P
    J --> P
    I --> P
    O --> C

    P -->|Override Defined| Q[Apply Override Level]
    P -->|No Override| R[Use Classified Level]

    Q --> S{Final Risk Level}
    R --> S

    S -->|LOW| T[Auto-Approve]
    S -->|MEDIUM| U{Agent Trust Level}
    S -->|HIGH| V[Require Approval]
    S -->|CRITICAL| C

    U -->|Trusted Agent| T
    U -->|Untrusted Agent| V

    V --> W{User Response}
    W -->|Approve| X[Execute Action]
    W -->|Reject| Y[Block Action]
    W -->|Timeout| Y

    T --> X
    X --> Z[Record Decision]
    Y --> Z
    C --> Z
```

## Risk Levels

### LOW
- **Behavior**: Auto-approved
- **Examples**: Read files, list directories, run tests, git status
- **Patterns**: `read`, `list`, `get`, `show`, `test`

### MEDIUM
- **Behavior**: Edits allowed, commands need confirmation
- **Examples**: npm install, git commit, file modifications
- **Patterns**: `write`, `install`, `commit`, `build`

### HIGH
- **Behavior**: Requires explicit approval with warning
- **Examples**: Authentication changes, database migrations, deployments
- **Patterns**: `auth`, `migrate`, `deploy`, `production`

### CRITICAL
- **Behavior**: Auto-rejected, never allowed
- **Examples**: Force push, terraform destroy, rm -rf, DROP DATABASE
- **Patterns**: `--force`, `destroy`, `rm -rf`, `DROP`

## Configurable Policies

Risk policies can be customized via JSON/YAML configuration:

```yaml
risk_policy:
  patterns:
    - pattern: "npm install"
      level: MEDIUM
      description: "Package installation"
    - pattern: "git push --force"
      level: CRITICAL
      description: "Force push is dangerous"

  overrides:
    - pattern: "npm install --save-dev"
      level: LOW
      description: "Dev dependencies are safe"

  allowed_paths:
    - "/src/**"
    - "/tests/**"

  blocked_paths:
    - "/.env"
    - "/secrets/**"
```
