# Memory Architecture Diagram

This diagram shows the four-tier memory system.

```mermaid
graph TB
    subgraph "Tier 0: Immutable Audit"
        T0A[Task Runs]
        T0B[Approval Logs]
        T0C[Cost Records]
        T0D[Health Samples]
    end

    subgraph "Tier 1: Authoritative"
        T1A[ADRs]
        T1B[Risk Policies]
        T1C[project_state.json]
        T1D[Workflow Definitions]
    end

    subgraph "Tier 2: Working Knowledge"
        T2A[Runbooks]
        T2B[Agent Prompts]
        T2C[Error Patterns]
        T2D[Session Context]
    end

    subgraph "Tier 3: Ephemeral Cache"
        T3A[Raw Outputs]
        T3B[Scratch Files]
        T3C[Temp Results]
        T3D[Working Memory]
    end

    T3A -->|Summarize| T2D
    T3B -->|Promote| T2C
    T2D -->|Archive| T1C
    T2C -->|Codify| T1B
    T1A -->|Audit| T0A
    T1C -->|Log| T0B

    WriteGate[Write Gate] --> T1A
    WriteGate --> T1B
    WriteGate --> T1C

    Librarian[Memory Librarian] --> T2A
    Librarian --> T2B
    Librarian --> T2C

    Agents[Agent Processes] --> T3A
    Agents --> T3B
    Agents --> T3C
    Agents --> T3D

    ReadAll[Read Access] -.-> T0A
    ReadAll -.-> T1A
    ReadAll -.-> T2A
    ReadAll -.-> T3A
```

## Memory Tiers

### Tier 0: Immutable Audit (Write-Once)
- **Purpose**: Permanent audit trail
- **Access**: Append-only, no modifications
- **Contents**:
  - Task execution records
  - Approval/rejection logs
  - Cost and usage records
  - Health check samples
- **Retention**: Indefinite

### Tier 1: Authoritative (Controlled Write)
- **Purpose**: Source of truth for system configuration
- **Access**: Write via WriteGate with approval
- **Contents**:
  - Architecture Decision Records (ADRs)
  - Risk classification policies
  - Project state (project_state.json)
  - Workflow definitions
- **Retention**: Version controlled

### Tier 2: Working Knowledge (Agent-Managed)
- **Purpose**: Operational knowledge and patterns
- **Access**: Write via Memory Librarian
- **Contents**:
  - Operational runbooks
  - Agent prompts and personas
  - Error patterns and fixes
  - Session context summaries
- **Retention**: Pruned by age/relevance

### Tier 3: Ephemeral Cache (Free Write)
- **Purpose**: Temporary working data
- **Access**: Direct write by agents
- **Contents**:
  - Raw command outputs
  - Scratch files
  - Intermediate results
  - Active working memory
- **Retention**: Session-scoped, auto-cleaned

## Data Flow

```mermaid
sequenceDiagram
    participant Agent
    participant T3 as Tier 3 (Cache)
    participant Lib as Librarian
    participant T2 as Tier 2 (Working)
    participant Gate as WriteGate
    participant T1 as Tier 1 (Auth)
    participant T0 as Tier 0 (Audit)

    Agent->>T3: Write raw output
    T3->>Lib: Trigger summarization
    Lib->>T2: Store pattern

    Note over T2,T1: Pattern becomes policy

    T2->>Gate: Request promotion
    Gate->>Gate: Require approval
    Gate->>T1: Write policy

    Note over T1,T0: Policy execution logged

    T1->>T0: Log audit record
```

## Shared Memory (Cross-Agent)

For multi-agent workflows, SharedMemory provides:

```mermaid
graph LR
    A1[Agent 1] -->|write| SM[(Shared Memory)]
    A2[Agent 2] -->|read| SM
    A3[Agent 3] -->|wait_for| SM
    SM -->|notify| A3
```

- **Thread-safe** key-value storage
- **Lock-based** write coordination
- **Change history** tracking
- **Wait-for-key** capability with timeouts
