# Agent Coordination Diagram

This diagram shows the advanced agent coordination patterns.

## Agent Handoff Flow

```mermaid
sequenceDiagram
    participant A1 as Claude Code
    participant HM as HandoffManager
    participant SM as SharedMemory
    participant A2 as Gemini CLI

    Note over A1: Working on task...
    A1->>A1: Hit rate limit

    A1->>HM: prepare_handoff()
    activate HM
    HM->>HM: Generate handoff_id
    HM->>HM: Build HandoffContext
    Note over HM: task_summary<br/>completed_work<br/>remaining_work<br/>files_modified

    HM->>SM: Store shared_state
    SM-->>HM: Stored

    HM-->>A1: HandoffContext
    deactivate HM

    A1->>HM: execute_handoff()
    activate HM
    HM->>HM: Generate prompt
    HM->>A2: Start with context
    activate A2

    HM-->>A1: HandoffResult
    deactivate HM

    Note over A2: Continues work...
    A2->>SM: Read shared_state
    SM-->>A2: Context data
    A2->>A2: Complete task
    A2-->>A1: Task complete
    deactivate A2
```

## Handoff Reasons

```mermaid
graph TD
    HR[Handoff Reasons] --> CM[CAPABILITY_MISMATCH]
    HR --> RL[RATE_LIMITED]
    HR --> TC[TASK_COMPLETE]
    HR --> ES[ESCALATION]
    HR --> SP[SPECIALIZATION]
    HR --> FR[FAILURE_RECOVERY]
    HR --> UR[USER_REQUESTED]
    HR --> LB[LOAD_BALANCING]

    CM --> |"Agent lacks skill"| A2[Route to capable agent]
    RL --> |"Hit API limits"| A3[Route to available agent]
    TC --> |"Sub-task done"| A4[Route to next agent]
    ES --> |"Need more power"| A5[Route to Opus]
    SP --> |"Need specialist"| A6[Route to domain expert]
    FR --> |"Agent failed"| A7[Route to backup]
    UR --> |"User requested"| A8[Route to specified]
    LB --> |"Distribute load"| A9[Route to least busy]
```

## Shared Memory Pattern

```mermaid
graph TB
    subgraph "Workflow: feature-123"
        SM[(SharedMemory<br/>workflow-123)]

        A1[Agent 1<br/>Backend] -->|write 'api_spec'| SM
        A2[Agent 2<br/>Frontend] -->|wait_for 'api_spec'| SM
        SM -->|notify| A2

        A2 -->|write 'components'| SM
        A3[Agent 3<br/>Tests] -->|wait_for 'components'| SM
        SM -->|notify| A3

        A3 -->|write 'test_results'| SM
        A4[Agent 4<br/>Review] -->|read_all| SM
    end

    subgraph "Memory Operations"
        OPS[Operations]
        OPS --> R[read - Get value]
        OPS --> W[write - Set with lock]
        OPS --> D[delete - Remove key]
        OPS --> C[clear - Remove all]
        OPS --> WF[wait_for - Block until set]
        OPS --> WC[wait_for_condition - Block until true]
    end
```

## Voting/Consensus Flow

```mermaid
sequenceDiagram
    participant O as Orchestrator
    participant VC as VotingCoordinator
    participant A1 as Claude Code
    participant A2 as Gemini CLI
    participant A3 as Codex CLI

    O->>VC: create_session("architecture_choice")
    activate VC
    VC->>VC: Set deadline
    VC->>VC: Define options

    par Notify all agents
        VC->>A1: Vote requested
        VC->>A2: Vote requested
        VC->>A3: Vote requested
    end

    A1->>VC: cast_vote("microservices", confidence=0.8)
    A2->>VC: cast_vote("monolith", confidence=0.6)
    A3->>VC: cast_vote("microservices", confidence=0.9)

    VC->>VC: tally_votes()
    Note over VC: microservices: 2 votes<br/>monolith: 1 vote<br/>Winner: microservices

    VC-->>O: VotingResult
    deactivate VC
```

## Swarm Coordination

```mermaid
graph TB
    subgraph "Task Decomposition"
        T[Complex Task] --> D[TaskDecomposer]
        D --> S1[Subtask 1]
        D --> S2[Subtask 2]
        D --> S3[Subtask 3]
        D --> S4[Subtask 4]
    end

    subgraph "Swarm Execution"
        SC[SwarmCoordinator]
        S1 --> SC
        S2 --> SC
        S3 --> SC
        S4 --> SC

        SC -->|assign| A1[Agent 1]
        SC -->|assign| A2[Agent 2]
        SC -->|assign| A3[Agent 3]
        SC -->|queue| Q[(Task Queue)]

        A1 -->|complete| R1[Result 1]
        A2 -->|complete| R2[Result 2]
        A3 -->|complete| R3[Result 3]
        Q -->|dequeue| A1
    end

    subgraph "Result Aggregation"
        R1 --> RA[ResultAggregator]
        R2 --> RA
        R3 --> RA
        RA --> FR[Final Result]
    end
```

## Coordination Strategies

| Strategy | Description | Use Case |
|----------|-------------|----------|
| ROUND_ROBIN | Cycle through agents | Even distribution |
| CAPABILITY_MATCH | Match skills to task | Specialized work |
| LOAD_BALANCED | Assign to least busy | High throughput |
| BROADCAST | Send to all agents | Voting, consensus |
| HIERARCHICAL | Manager delegates | Complex projects |

## Decomposition Strategies

| Strategy | Description | Use Case |
|----------|-------------|----------|
| SEQUENTIAL | One after another | Dependent tasks |
| PARALLEL | All at once | Independent tasks |
| HIERARCHICAL | Tree structure | Complex breakdown |
| MAP_REDUCE | Split, process, merge | Data processing |
| PIPELINE | Chain of transforms | ETL workflows |

## Aggregation Strategies

| Strategy | Description | Use Case |
|----------|-------------|----------|
| MERGE | Combine all results | Complementary outputs |
| VOTE | Majority wins | Decision making |
| FIRST | First valid result | Speed priority |
| BEST | Highest quality | Quality priority |
| CONSENSUS | Agreement required | Critical decisions |
| WEIGHTED | Score-based merge | Confidence weighting |
